VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cShapeEllipse"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'If you have a "good eye", then you will have noticed, that the "lighting-effect" of
'the gray circle (done in cShapeCircle within this Demo) somehow "does not look entirely right"
'This is due to the fact, that we provided the radial gradient there only with two simple
'colorstops, between which "only" a linear interpolation took place ...
'So, this example tries, to show you the construction of a nicer "3D-glowing-effect"
'(looking "somewhat more right" now ;-) ... thereby introducing the usage of a Helper-
'Method in cCairoPattern, which can place ColorStops, following a gaussian-function
'(you know, this "bell-curve-thingy" you probably heard about in scool)
'
'The light in this example is "falling in" vertically.

Private WithEvents ROuter As cControlPoint
Attribute ROuter.VB_VarHelpID = -1
Private WithEvents CenterDrag As cControlPoint
Attribute CenterDrag.VB_VarHelpID = -1

Public Sub Init(Controlpoints As cControlPoints, ByVal X As Double, ByVal Y As Double, ByVal RadiusOuter As Double)
  Set ROuter = Controlpoints.Add("ROuter" & ObjPtr(Me), X + RadiusOuter, Y, vbGreen, 6)
  Set CenterDrag = Controlpoints.Add("CenterDrag" & ObjPtr(Me), X, Y, vbMagenta, 9)
End Sub

Public Sub Draw(CC As cCairoContext)
Dim Pat As cCairoPattern
  CC.Save
    'the following transforms are "global" (for each of the three "Sub-Ellipses" below)...
    CC.TranslateDrawings CenterDrag.X, CenterDrag.Y 'all of the below drawings will now work relative to the Center-Point of this Shape-Object
    CC.ScaleDrawings 1, 0.88 'and since radial patterns are circular, we use the CC.Arc (Circle) Function below also for our Path-Defs - the Ellipse occurs simply because of less scaling in y-direction

    '1.) our first ellipse (drawn at the bottom of the folowing ones) ensures the DropShadow-Effect
    CC.Save '<- we save here, because we want to apply an additional transform on this "Shadow-Ellipse"
      CC.TranslateDrawings 0, RadiusOuter * 0.5 'this shifts the center-point down (half our outer radius)
      CC.ScaleDrawings 1.5, 1.3 'and here somewhat more "shrinking" in y-direction (for an even "more elliptic" 3D-shadow)
      
      CC.Arc 0, 0, RadiusOuter 'all the Circle-Path-Defs (not only this one) can use (0,0) now for their center, as well as our "normal" outer Radius-Value
        Set Pat = Cairo.CreateRadialPattern(0, 0, RadiusOuter, 0, 0, 0) '
        Pat.AddGaussianStops_TwoColors RGB(0, 55, 99), RGB(0, 55, 99), 0, 1
      CC.Fill , Pat
    CC.Restore
    
    
    '2.) our second, the blue "Main"-Ellipse - here we just use the global transform (defined at the top)...
    '    so, the few "extra-offsets" in the Pattern-Create-Call are calculated "by hand"
    '    this already ensures the "inside glowing" effect - defined over a "blueish" radial gradient,
    '    which is a bit "misplaced" from the center of our Circle-Path (ensured by the following CC.Arc-Call)
    CC.Arc 0, 0, RadiusOuter
      'as said above, this radial patterns:
      'outer-radius: slightly larger than the radius of the path above, centerpoint slightly shifted down a bit
      'inner-radius: as in most cases the inner radius is at zero, but the focal-point of the "glow-source" is downshifted even more than the center of the outer radius
      Set Pat = Cairo.CreateRadialPattern(0, -RadiusOuter * 0.16, RadiusOuter * 1.66, _
                                          0, RadiusOuter * 0.61, 0)
      'and here we use again our gaussian "Color-Stop-Creation-Helper" (from color "very-dark-blue" to the "glowing light-blue" ...along outer-to-inner-radius-direction
      Pat.AddGaussianStops_TwoColors RGB(0, 0, 66), RGB(130, 190, 255), 1, 1 ', gpLess
    CC.Fill , Pat
    
    
    '3.) finally the "Shine-Effect-Ellipse" at the Top of this Shape
    '    this is somewhat similar to the Shadow-Ellipse in 1.) - but now we use "near white" instead of "near black" for the gradient
    '    and other than the drop-shadow-placement, we shift the whole thing not downwards, but upwards instead (again, relative from our center-point)
    CC.Save 'as in 1.) we wrap this code-block in an additional Save/Restore, since we want to use additional transforms
      CC.TranslateDrawings 0, -RadiusOuter * 0.5 'as said, now we center the whole thing half a radius-distance upwards first
      CC.ScaleDrawings 0.8, 0.55 'and as in 1.) we apply an extra-shrinking of the ellipse in y-direction, but other than in 1.) we use scales below 1, since we want to draw it smaller than the main-ellipse
      
      CC.Arc 0, 0, RadiusOuter '<-now as always, the same Path-Definition-Call is possible, due to our "extra-transformations" above
        Set Pat = Cairo.CreateRadialPattern(0, 0, RadiusOuter, 0, -RadiusOuter * 0.25, 0) 'the center of the shine is slightly shifted upwards (over the 5th paramter)
        Pat.AddGaussianStops_TwoColors RGB(200, 255, 255), vbWhite, 0, 0.95
      CC.Fill , Pat
    CC.Restore
    
  CC.Restore
End Sub

Public Property Get RadiusOuter() As Double
  RadiusOuter = ROuter.X - CenterDrag.X
End Property

'Control-Point Movement-Events are received below, and we will act accordingly with the necessary adaptions
Private Sub Router_PositionChanging(NewX As Double, NewY As Double)
  NewY = CenterDrag.Y

  If NewX - CenterDrag.X < 20 Then NewX = CenterDrag.X + 20   'we restrict the outer Radius to min 20 pixels
  If NewX - CenterDrag.X > 150 Then NewX = CenterDrag.X + 150   'we restrict the outer Radius to man 150 pixels
End Sub

Private Sub CenterDrag_PositionChanging(NewX As Double, NewY As Double)
  ROuter.X = NewX + RadiusOuter
  ROuter.Y = NewY
End Sub



